package nemosofts.voxradio.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuHost;
import androidx.core.view.MenuProvider;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.material.Toasty;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.adapter.home.AdapterHome;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.executor.LoadHome;
import nemosofts.voxradio.fragment.search.FragmentSearch;
import nemosofts.voxradio.interfaces.HomeListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.helper.DBHelper;
import nemosofts.voxradio.utils.helper.Helper;

@UnstableApi
public class FragmentHome extends Fragment {

    DBHelper dbHelper;
    Helper helper;
    ProgressBar progressBar;
    FrameLayout frameLayout;
    RecyclerView rvHome;
    AdapterHome adapterHome;
    ArrayList<ItemPost> arrayList;
    private String errorMsg;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_home, container, false);

        helper = new Helper(requireActivity());

        arrayList = new ArrayList<>();
        dbHelper = new DBHelper(requireActivity());

        progressBar = rootView.findViewById(R.id.pb_home);
        frameLayout = rootView.findViewById(R.id.fl_empty);

        rvHome = rootView.findViewById(R.id.rv_home);
        LinearLayoutManager llm = new LinearLayoutManager(requireActivity());
        rvHome.setLayoutManager(llm);
        rvHome.setItemAnimator(new DefaultItemAnimator());

        loadHome();

        addMenuProvider();
        return rootView;
    }

    private void loadHome() {
        if (!NetworkUtils.isConnected(requireContext())) {
            errorMsg = getString(R.string.err_internet_not_connected);
            setEmpty();
            return;
        }

        LoadHome loadHome = new LoadHome(new HomeListener() {
            @Override
            public void onStart() {
                frameLayout.setVisibility(View.GONE);
                rvHome.setVisibility(View.GONE);
                progressBar.setVisibility(View.VISIBLE);
            }

            @Override
            public void onEnd(String success, String message, ArrayList<ItemPost> arrayListPost) {
                if (getActivity() == null) {
                    return;
                }
                if (success.equals("1")) {
                    if (!arrayListPost.isEmpty()){
                        setPostSticky(arrayListPost);

                        arrayList.addAll(arrayListPost);
                        if (Boolean.TRUE.equals(Callback.getIsAdsStatus())){
                            arrayList.add(new ItemPost("100","ads","ads", false));
                        }
                        adapterHome = new AdapterHome(getActivity(), arrayList);
                        rvHome.setAdapter(adapterHome);
                        setEmpty();
                    } else {
                        errorMsg = getString(R.string.err_no_data_found);
                        setEmpty();
                    }
                } else if (success.equals("-2")) {
                    Toasty.makeText(requireActivity(), message , Toasty.ERROR);
                } else {
                    errorMsg = getString(R.string.err_server);
                    setEmpty();
                }
                progressBar.setVisibility(View.GONE);
            }
        }, helper.getAPIRequest(Method.METHOD_HOME, 0, dbHelper.getRecentIDs("10"),
                "", "", "", "", "", "", "",
                "", "", "", "", null));
        loadHome.execute();
    }

    private void setPostSticky(ArrayList<ItemPost> arrayListPost) {
        if (Callback.getArrayListPlay().isEmpty()) {
            for (int i = 0; i < arrayListPost.size(); i++) {
                if(!arrayListPost.get(i).getArrayListRadio().isEmpty()) {
                    Callback.setArrayListPlay(arrayListPost.get(i).getArrayListRadio());
                    try {
                        GlobalBus.getBus().postSticky(Callback.getArrayListPlay().get(0));
                    } catch (Exception e) {
                        Log.e("FragmentHome", "Error in postSticky", e);
                    }
                    break;
                }
            }
        }
    }

    public void setEmpty() {
        if (!arrayList.isEmpty()) {
            rvHome.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
            progressBar.setVisibility(View.GONE);
        } else {
            rvHome.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);
            progressBar.setVisibility(View.INVISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errorMsg);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> {
                myView.findViewById(R.id.iv_empty).setVisibility(View.GONE);
                myView.findViewById(R.id.pb_empty).setVisibility(View.VISIBLE);
                new Handler().postDelayed(() -> {
                    myView.findViewById(R.id.iv_empty).setVisibility(View.VISIBLE);
                    myView.findViewById(R.id.pb_empty).setVisibility(View.GONE);
                    loadHome();
                }, 500);
            });

            frameLayout.addView(myView);
        }
    }

    private void addMenuProvider() {
        MenuHost menuHost = requireActivity();
        menuHost.addMenuProvider(new MenuProvider() {
            @Override
            public void onCreateMenu(@NonNull Menu menu, @NonNull MenuInflater menuInflater) {
                menu.clear();
                menuInflater.inflate(R.menu.menu_search, menu);

                // Configure the search menu item
                MenuItem item = menu.findItem(R.id.menu_search);
                item.setShowAsAction(MenuItem.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItem.SHOW_AS_ACTION_IF_ROOM);
                SearchView searchView = (SearchView) item.getActionView();
                if (searchView != null) {
                    searchView.setOnQueryTextListener(queryTextListener);
                }
            }

            @Override
            public boolean onMenuItemSelected(@NonNull MenuItem menuItem) {
                // Handle menu item selection if necessary
                return false;
            }
        }, getViewLifecycleOwner());
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(@NonNull String s) {
            Callback.setSearchItem(s.replace(" ", "%20"));
            FragmentSearch fSearch = new FragmentSearch();
            FragmentManager fm = getParentFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(Objects.requireNonNull(fm.findFragmentByTag(getString(R.string.nav_home))));
            ft.add(R.id.fragment, fSearch, getString(R.string.search));
            ft.addToBackStack(getString(R.string.search));
            ft.commit();
            return true;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            return false;
        }
    };

    @SuppressLint("NotifyDataSetChanged")
    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onEquilizerChange(ItemCat itemCat) {
        adapterHome.onEqualizerChange();
        GlobalBus.getBus().removeStickyEvent(itemCat);
    }

    @Override
    public void onStart() {
        super.onStart();
        GlobalBus.getBus().register(this);
    }

    @Override
    public void onStop() {
        GlobalBus.getBus().unregister(this);
        super.onStop();
    }
}